
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD.View
{
    internal class EvaluationSheet : PI.FM.N000.Base.BL.DBD.BaseTable<BO.View.EvaluationSheet>
    {
        #region Static factory
        private static EvaluationSheet _factory = null;

        public static EvaluationSheet DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new EvaluationSheet();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_EvaluationSheetView";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Name", "Name"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Abbreviation", "Abbreviation"));
            Add(new PI.FM.N000.Base.BL.DBD.DecimalProperty("Salary", "Salary"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("From", "From"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("To", "To"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Weight", "Weight"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("EvaluationSheetID", "EvaluationSheetID"));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 10
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.View.EvaluationSheet>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.View.EvaluationSheet.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("ID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("ClassID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("PointPercent", Gemini.Core.BL.DAL.SqlTypes.Int));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_EvaluationSheetView_RestoreBySearch";
            }
        }
        #endregion
    }
}
